/* fsusage.c -- return space usage of mounted filesystems
   Copyright (C) 1991, 1992, 1996 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/* patch for os/2 */

#define INCL_DOSFILEMGR
#define INCL_DOSERRORS

#include <os2.h>

#include "sysconfig.h"

#include <stdlib.h>
#include <sys/types.h>

#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#include "fsusage.h"

/* Return the number of TOSIZE-byte blocks used by
   BLOCKS FROMSIZE-byte blocks, rounding away from zero.
   TOSIZE must be positive.  Return -1 if FROMSIZE is not positive.  */

static long adjust_blocks (long blocks,int fromsize,int tosize)
{
  if (tosize <= 0)
    abort ();
  if (fromsize <= 0)
    return -1;

  if (fromsize == tosize)       /* e.g., from 512 to 512 */
    return blocks;
  else if (fromsize > tosize)   /* e.g., from 2048 to 512 */
    return blocks * (fromsize / tosize);
  else                          /* e.g., from 256 to 512 */
    return (blocks + (blocks < 0 ? -1 : 1)) / (tosize / fromsize);
}


int
get_fs_usage (path, disk, fsp)
     const char *path;
     const char *disk;
     struct fs_usage *fsp;
{
 char buf1[1024];
 FSALLOCATE fsaBuffer     = {0};
 APIRET  rc               = NO_ERROR;

  if (_abspath (buf1, path ,sizeof buf1))
    return -1;
  rc = DosQueryFSInfo(buf1[0] - 'A'+1,
                      FSIL_ALLOC,
                      (PVOID)&fsaBuffer,
                      sizeof(FSALLOCATE));
  if (rc != NO_ERROR)
    return -1;

  fsp->fsu_blocks = adjust_blocks (fsaBuffer.cUnit,fsaBuffer.cSectorUnit * fsaBuffer.cbSector, 512);
  fsp->fsu_bavail = adjust_blocks (fsaBuffer.cUnitAvail, fsaBuffer.cSectorUnit * fsaBuffer.cbSector, 512);
  return 0;
}

